/* Denne kode er hente fra SGI. */ 



#include <gl/gl.h>
#include <dmedia/vl.h>
#include "grab.h"

    static VLServer grab_svr;
    static VLPath grab_path;
    static VLNode grab_src, grab_drn;
    static VLControlValue grab_val;
    static VLBuffer grab_buffer;
    static VLInfoPtr grab_info;

    static char *grab_dataPtr;
   
    static int grab_c;
    static int grab_xsize;
    static int grab_ysize;


/* initaliserer videograbberen, programmet avsluttes ved feil*/

void openvideo()
{
    /* Connect to the daemon */
    if (!(grab_svr = vlOpenVideo(""))) 
	error_exit();

    /* Set up a drain node in memory */
   grab_drn = vlGetNode(grab_svr, VL_DRN, VL_MEM, VL_ANY);
    
    /* Set up a source node on any video source  */
   grab_src = vlGetNode(grab_svr, VL_SRC, VL_VIDEO, VL_ANY);

    /* Create a path using the first device that will support it */
     grab_path = vlCreatePath(grab_svr, VL_ANY, grab_src, grab_drn); 

    /* Set up the hardware for and define the usage of the path */
    if ((vlSetupPaths(grab_svr, (VLPathList)&grab_path, 1, VL_SHARE, VL_SHARE)) < 0)
	error_exit();

     grab_val.intVal = VL_PACKING_Y_8_P;
    vlSetControl(grab_svr, grab_path, grab_drn, VL_PACKING, &grab_val);
    
    /* Get the video size */
    vlGetControl(grab_svr, grab_path, grab_drn, VL_SIZE, &grab_val);
    grab_xsize =grab_val.xyVal.x;
    grab_ysize =grab_val.xyVal.y;

   /* Create and register a buffer for 1 frame */
   grab_buffer = vlCreateBuffer(grab_svr, grab_path, grab_drn, 1);
    if (grab_buffer == NULL)
	error_exit();	
    vlRegisterBuffer(grab_svr,grab_path, grab_drn, grab_buffer);
    
    /* Begin the data transfer */
    if (vlBeginTransfer(grab_svr, grab_path, 0, NULL))
      {
      printf("Grabber, feil!\n");
      error_exit();
      }
}


/* Denne funksjonen grabber et bildet og returnerer en peker til dataen*/
char *grab()
{      
  sginap(1);
    do {
    	grab_info = vlGetNextValid(grab_svr, grab_buffer);
    } while (!grab_info);

    /* Get a pointer to the frame */
    grab_dataPtr = vlGetActiveRegion(grab_svr, grab_buffer, grab_info);
	
    
   
    
    return grab_dataPtr;
   
}

/*Lar grabber ta et nytt bilde */
void unlockbuffer()
{
  /* Finished with frame, unlock the buffer */
    vlPutFree(grab_svr,grab_buffer);
  
}




/* Frigjor grabberen igjen */
void closevideo()
{
 vlEndTransfer(grab_svr, grab_path);      
     /* Cleanup before exiting */
    vlDeregisterBuffer(grab_svr,grab_path, grab_drn, grab_buffer);
    vlDestroyBuffer(grab_svr, grab_buffer);
    vlDestroyPath(grab_svr, grab_path);
    vlCloseVideo(grab_svr);
}

/* to funksjonener som returnerer opplosningen*/
int grabsizex()
{
  return grab_xsize;
}


int grabsizey()
{
  return grab_ysize;
}


