#include <stdlib.h>
#include <stdio.h>
#include <gl/gl.h>
#include <sys/types.h>
#include <time.h>

#include <dmedia/vl.h>
#include "grab.h"
#include "analyze.h"
 
/*program instillinger som hentes fra logfil*/


static long gjennomsnittsoppdatering;/*hvor raskt bilde skal oppdatere seg*/
static long omraade;                 /*Hvor stort omraade */
static long omraadedivisjon;         /*omraade sensitivitet. samletstoy / 							  omraadedivisjon*/

static long minimumdifferanse;       /*minimum differanse*/

static long stoylaering;             /*laere faktor*/
static long stoyglemming;            /*glemme faktor*/
static long minantallpunkter;        /*min for at den skal trigge*/
static long maksantallpunkter;       /*max for at den skal trigge*/
static long kaliberingsbilde;        /*hvormange bilder en skal ta for den skal 
				             kunne ha mulighet til aa kunne trigge*/
static long visvindu;                /* 0 = ikke vis vindu */
static long kunlyse;                 /*1=hvis en kun skal finne lysere 							 objekter*/
static long brukemaske;              /*1+hvis bruke maske*/

/* ikke program instillinger */



static int openvideoch=0;          /*test verdi for video grabber er 							     initalisert*/
static int gjennomsnittsbildech=0; /*test verdi for buffere generert 0/1 */
                                  

/*peker til buffer som programmet trenger */
static long *gjennomsnittsbilde;   /*gjennomsnittsbilde*/ 
static long *differanse;           /*differansebildet */
static long *stoy;                 /*stoybildet*/
static char *funnet;               /*hvilket punket som har blitt funnet 0=ikke funnet 0xff+funnet*/
static long *winbuffer;            /*bildet som visespaa skjermen*/
static char *mask;                 /*maske bildet*/

static long antallfunnet;          /*antall piksler funnet i bildet*/
static long behandlet;             /*antall bilder behandlet siden siste deteksjon */

static  long win;                  /*vindu id*/
static  int xstorrelse;            /*x storrelse paa bildet fra grabberen*/
static  int ystorrelse;            /*x storrelse paa bildet fra grabberen*/
static  char *datafragrabber;      /*peker som blir bruke til aa peke paa data fra grabberen*/


static long stoyfilter[]=
{
  0,0,

  0,1,
  0,-1,
  1,0,
  -1,0,

  -1,1,
  1,1,
  1,-1,
  -1,-1,

  0,2,
  2,0,
  0,-2,
  -2,0,

  -1,2,
  1,2,
  2,1,
  2,-1,
  1,-2,
  -1,-2,
  -2,-1,
  -2,1,
};
static long stoyfi[21];
/* stoyfilter hvilke pikler i omraadet rundt som en skal ta hendsyn til.
   stoyfi blir generert av stoyfilter for aa kunne spare insturksjoner.*/




int analyze()
{
  int n;                  /* Trenger en variable til div for lokker*/

  if(openvideoch==0)
  {
    leskonfig();          /*leser konfigfil som setter in de nodvendig verdier inn i porgrammet*/
    openvideo();          /* Gjor klar video grabberen*/
    xstorrelse=grabsizex();
    ystorrelse=grabsizey();
    

    for(n=0;n<21*2;n+=2)   /* prekalulerer talbell stoyfi*/
      stoyfi[n/2]=stoyfilter[n]+stoyfilter[n+1]*xstorrelse;
	
    openvideoch=1;

    /* allokerer alle buffere som trenges */
  
    if(gjennomsnittsbildech==0)
      {
      behandlet=0;
      gjennomsnittsbilde=malloc(xstorrelse*ystorrelse*sizeof(long));
      if(gjennomsnittsbilde==0)
	{
	  printf("Ikke nok minne!");
	  exit(1);

	}
      differanse=malloc(xstorrelse*ystorrelse*sizeof(long));
      if(differanse==0)
	{
	  printf("Ikke nok minne!");
	  exit(1);

	}
      stoy=malloc(xstorrelse*ystorrelse*sizeof(long));
      if(stoy==0)
	{
	  printf("Ikke nok minne!");
	  exit(1);
	}
   
      funnet=malloc(xstorrelse*ystorrelse*sizeof(char));
      if(funnet==0)
	{
	  printf("Ikke nok minne!");
	  exit(1);
	}
      else for(n=0;n<xstorrelse*ystorrelse;n++)funnet[n]=0;

      winbuffer=(long *)malloc(xstorrelse*ystorrelse*sizeof(long));
      if(winbuffer==0)      
	{
	  printf("Ikke nok minne!");
	  exit(1);
	}
      mask=malloc(xstorrelse*ystorrelse*sizeof(char));   
      if(mask==0)
	{
	  printf("Ikke nok minne!");
	  exit(1);
	}     
      else hentmask();    /* henter mask bilde hvis satt paa*/
      gjennomsnittsbildech=1;       
      }


    if(visvindu==1)
      {  
	createRGBwin();
	visvindu=2;
      }
    
  }
  
  datafragrabber=grab(); /*Grabber bilde*/

  laggjennomsnitt();     /*Starter bilde behaldlingen*/ 

  

  if(visvindu==2)  /*Viser skjerm bilde hvis paa*/
    {
    lagbildet();
    lrectwrite(0,0, (xstorrelse)-1, ystorrelse-1, (ulong *)winbuffer);        
    }
  behandlet++;


  /* Her tas avgjorelsen om programmet skal detektere noe */
  if(antallfunnet > minantallpunkter && antallfunnet <maksantallpunkter && behandlet>kaliberingsbilder )
    {
      behandlet=0;
      lagbildet();
      unlockbuffer();
 
      return 1;
    }
  unlockbuffer();
  return 0;

}

/* Avslutter programmet */
void analyseclose()
{
  closevideo();
  free(gjennomsnittsbilde);
  free(differanse);
  free(stoy);
  free(funnet);
  free(winbuffer);
  openvideoch=0;
  gjennomsnittsbildech=0;
  
}

void laggjennomsnitt()
{
  int x,n,y;
  long diff,st,sum;
  antallfunnet=0;

  /* kaller rutine for lyse&mokeobjekter eller bare lyse*/
  if(kunlyse==1)kunlyseobjekter();
  else lyseogmorke();


  /* Denne doble loopen oppdaterer funnet */ 
  /* Den setter 0xff i arry funnet der en deteksjon funnet sted*/
  /* 00 der det ikke er funnet */
  for(y=xstorrelse*2;y<((xstorrelse*ystorrelse)-(xstorrelse*2));y+=xstorrelse)
	for(x=2;x<xstorrelse-2;x++)
	
	{
	  sum=x+y;
	  st=0;

	  if(mask[sum]==0)
	    {

	      for(n=0;n<omraade;n++)/*finner omraade stoyen*/
		{
		  st+=stoy[sum+stoyfi[n]];
		}  

	      /* Bestemmer om punketet blir funnet*/
	  if(differanse[sum]>minimumdifferanse+(st/omraadedivisjon))	    
	  {
	    funnet[sum]=0xff;
	  
	    antallfunnet++; /* teller oppantall punketer som er detektert*/

	  }
	  else funnet[sum]=0;
	 }
	  
	}

}

/* Denne funksjonen oppdaterer baade stoybildet og gjennomsnittsbidet*/
void kunlyseobjekter()
{
 
 int n,diff;
 for(n=0;n<xstorrelse*ystorrelse;n++)

    {
      diff=(datafragrabber[n])-(gjennomsnittsbilde[n]>>16);
      gjennomsnittsbilde[n]+=diff*gjennomsnittsoppdatering;

     differanse[n]=diff;
	
   
     if(diff<0) diff=-diff;
    
	

      if (stoy[n]<(diff<<16))
	stoy[n]+=stoylaering;
      else
	if(stoy[n]>stoyglemming)stoy[n]-=stoyglemming;
    }
}

/* Denne funksjonen oppdaterer baade stoybildet og gjennomsnittsbidet*/
void lyseogmorke()
{  
  int n,diff;
  for(n=0;n<xstorrelse*ystorrelse;n++)

    {
      diff=(datafragrabber[n])-(gjennomsnittsbilde[n]>>16);
      gjennomsnittsbilde[n]+=diff*gjennomsnittsoppdatering;   
   
     if(diff<0) diff=-diff;
    
     differanse[n]=diff;
	

      if (stoy[n]<(diff<<16))
	stoy[n]+=stoylaering;
      else
	if(stoy[n]>stoyglemming)stoy[n]-=stoyglemming;
    }
}


/* intalisering av vindu */
void createRGBwin()
{
    prefsize(xstorrelse,ystorrelse);
    win = winopen("a199801");
    RGBmode();
    pixmode(PM_TTOB, 1);
    gconfig();
}

/* Denne lager bilde som skal vises paa skjerm og skrives til fil*/
void lagbildet()
{
  long teller;  
 
      for(teller=0;teller<xstorrelse*ystorrelse;teller++)

      if(funnet[teller]>1)
      winbuffer[teller]=(datafragrabber[teller]*0x0100+0xf0)&0x00ffff;
      else
      winbuffer[teller]=datafragrabber[teller]*0x010101;
    
}


/* koverterer mask.TIFF og Lastere det nye bilde i inn i buffer*/
void hentmask()
{
 FILE *fileptr;
 int n,r,g,b;
 if(brukemaske==1)
   {
    system("convert -size768x576 768x576 mask.TIFF mask.RGB"); 
    fileptr = fopen("mask.RGB", "r");
    if(fileptr) 
    {
    for(n=0;n<xstorrelse*ystorrelse;n++)
       {
	 r=getc(fileptr);
	 g=getc(fileptr);
	 b=getc(fileptr);
	 if(r==EOF||g==EOF||b==EOF)	  
	   {
	   break;
	   printf("Feil paa paa fil mask.RGB\n");
	   }

	 if(r>b&&r>g)mask[n]=0xff;
	 else mask[n]=0x00;
       }
      
	 fclose(fileptr);
    }
    else 
   {
    printf("mask.RGB, fil feil!\n");
   }
   }
   else
     {
         for(n=0;n<xstorrelse*ystorrelse;n++)
	 mask[n]=0;
     }

}


/*skrive bildet som ligger i winbuffer til fil "image.RGB"*/
void skrivbildet()
{
  long teller;
  FILE *filpek;
  char *t=winbuffer;  
  if (filpek = fopen("image.RGB", "w"))
    {
    for(teller=0;teller<xstorrelse*ystorrelse;teller++)
      {
      if ((fputc(t[teller*4+3], filpek)==EOF) || (fputc(t[teller*4+2], filpek)==EOF) || (fputc(t[teller*4+1], filpek)==EOF))	
      {
      printf("image.RGB, fil feil!\n");
      }
    }
    fclose(filpek);  
      }
  else{
    printf("image.RGB, fil feil!\n");
  }  
}


/* Skrive siste bilde fra grabber til fil "image.GRAY"*/
void lagGRAY()
{
  long x,y;
  long teller;
  FILE *filpek;
  char *t=datafragrabber;
  
  x= grabsizex();
  y= grabsizey();

 
 if (filpek = fopen("image.GRAY", "w"))
  {
    for(teller=0;teller<x*y;teller++)
      {

      if ((fputc(t[teller], filpek)==EOF) )
      
      {
      printf("image.RGB, fil feil\n");
      }
 
      }
   }  
   fclose(filpek);
}



/************ KOFIG LESING **************************************/

void leskonfig()
{

    int t;
    float tall;
    FILE *fileptr;
    char data[10000];
    

    for(t=0;t<10000;t++)data[t]='\0';

    fileptr = fopen("a199801.conf", "r"); 
     if(fileptr) 
   {

       t=fread(data,1,9000, fileptr);
       
        fclose(fileptr);
	 
	gjennomsnittsoppdatering=(long)(0x10000*sfinn("GJENNOMSNITTSOPPDATERING ",data));
	stoylaering=(long)0x10000*sfinn("STOYLAERING ",data);
	stoyglemming=(long)0x10000*sfinn("STOYGLEMMING ",data);
	omraade=(long)sfinn("OMRAADE ",data);
	if(omraade>21)omraade=21;
	omraadedivisjon=(long)0x10000*sfinn("OMRAADEDIVISJON ",data);
	minimumdifferanse=(long)sfinn("MINIMUMDIFFERANSE ",data);
	minantallpunkter=(long)sfinn("MINANTALLPUNKTER ",data);
	maksantallpunkter=(long)sfinn("MAKSANTALLPUNKTER ",data);
	brukemaske=(long)sfinn("BRUKMASKE ",data);
	kunlyse=(long)sfinn("KUNLYSE ",data);
	visvindu=(long)sfinn("VISVINDU ",data);
	if(visvindu!=0&&visvindu!=1)visvindu=0;
	kaliberingsbilder=(long)sfinn("KALIBRERINGSBILDER ",data);
	
   }

  else{
    printf("a199801.conf, fil feil!\n");
  }
   
	
}	


float sfinn(char *test,char *data)
{
  int n,t;
  float f;

 for(n=0;n<9000;n++)
    {
      if(test[0]==data[n])
	for(t=0;t<100;t++)
	  {
	  if(test[t]==' ')
	    {	       
	      f=ffinn(&data[n+t]);
	      return f;
	    }
	  if(test[t]!=data[n+t])t=1000;
	  }

    }
    return 0;
}

float ffinn(char *data)
{
  float f=0;
  float f2=1;
  int n=0;
  char *t;

  while(data[n]!='\0'&&data[n]!='\n'&&!(data[n]>='0'&&data[n]<='9'))  
  n++;
 

  while(data[n]>='0'&&data[n]<='9')
  {
    f=f*10+(data[n]-'0');
    n++;
  }
  if(data[n]=='.')
    {
    n++;
  
    while(data[n]>='0'&&data[n]<='9')
      {
	f2=f2/10;
	f=f+(f2*(data[n]-'0'));
	n++;
      }
    }

 return f;
 
}

/*************************** log fil ****************************************/

FILE *logfil;

void initlog()
{ 
  char *c;
  time_t t;
  t=time(NULL);
  c=asctime(localtime(&t));
  
 

if ((logfil=fopen("a199801.log","a"))==NULL)
  {
    printf("a199801.log, fil feil!\n");
  }
  else
  {
  fprintf(logfil,("Startet: "));
  fprintf(logfil,c);
  fclose(logfil);
  }
}

void log(int d)
{
  int n;
 
  char str[100]={""};
  char *c;
  time_t t;
  t=time(NULL);
  c=asctime(localtime(&t));
  
  for(n=0;n<100&c[n]!='\n';n++)
    str[n]=c[n];

  str[n]='\0';

if ((logfil=fopen("a199801.log","a"))==NULL)
  {
     printf("a199801.log, fil feil!\n");
  }
  else
  {  
  fprintf(logfil, "Detektnr: %i ",d);
  fprintf(logfil,str);
  fprintf(logfil," antallpunkterdetektert ");
  fprintf(logfil,"%i",antallfunnet);
  fprintf(logfil,"\n");
  fclose(logfil);
 
  }
}
 




























